/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MProcessPara;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;

@Process
public class BPartnerValidate
extends SvrProcess {
    int p_C_BPartner_ID = 0;
    int p_C_BP_Group_ID = 0;

    protected void prepare() {
        this.p_C_BPartner_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID);
        }
        if (this.p_C_BPartner_ID == 0 && this.p_C_BP_Group_ID == 0) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerGroupNotSelected"));
        }
        if (this.p_C_BP_Group_ID == 0) {
            MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"BPartnerNotFound") + " - C_BPartner_ID=" + this.p_C_BPartner_ID);
            }
            this.checkBP(bp);
        } else {
            Iterator it = new Query(this.getCtx(), "C_BPartner", "C_BP_Group_ID=?", this.get_TrxName()).setParameters(new Object[]{this.p_C_BP_Group_ID}).setOnlyActiveRecords(true).iterate();
            while (it.hasNext()) {
                this.checkBP((MBPartner)it.next());
            }
        }
        return "OK";
    }

    private void checkBP(MBPartner bp) throws SQLException {
        this.addLog(0, null, null, bp.getName() + ":");
        this.checkPayments(bp);
        this.checkInvoices(bp);
        bp.setTotalOpenBalance();
        bp.setActualLifeTimeValue();
        bp.saveEx();
        this.addLog(0, null, bp.getSO_CreditUsed(), Msg.getElement((Properties)this.getCtx(), (String)"SO_CreditUsed"));
        this.addLog(0, null, bp.getTotalOpenBalance(), Msg.getElement((Properties)this.getCtx(), (String)"TotalOpenBalance"));
        this.addLog(0, null, bp.getActualLifeTimeValue(), Msg.getElement((Properties)this.getCtx(), (String)"ActualLifeTimeValue"));
        this.commitEx();
    }

    private void checkPayments(MBPartner bp) {
        int changed = 0;
        MPayment[] payments = MPayment.getOfBPartner((Properties)this.getCtx(), (int)bp.getC_BPartner_ID(), (String)this.get_TrxName());
        int i = 0;
        while (i < payments.length) {
            MPayment payment = payments[i];
            if (payment.testAllocation()) {
                payment.saveEx();
                ++changed;
            }
            ++i;
        }
        if (changed != 0) {
            this.addLog(0, null, new BigDecimal(payments.length), Msg.getElement((Properties)this.getCtx(), (String)"C_Payment_ID") + " - #" + changed);
        }
    }

    private void checkInvoices(MBPartner bp) {
        int changed = 0;
        MInvoice[] invoices = MInvoice.getOfBPartner((Properties)this.getCtx(), (int)bp.getC_BPartner_ID(), (String)this.get_TrxName());
        int i = 0;
        while (i < invoices.length) {
            MInvoice invoice = invoices[i];
            if (invoice.testAllocation()) {
                invoice.saveEx();
                ++changed;
            }
            ++i;
        }
        if (changed != 0) {
            this.addLog(0, null, new BigDecimal(invoices.length), Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID") + " - #" + changed);
        }
    }
}

