/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.groovy;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Page;

public class GroovyInterpreter
extends GenericInterpreter {
    private Binding _global;
    private GroovyShell _ip;

    Binding getGlobalScope() {
        return this._global;
    }

    @Override
    public Object getNativeInterpreter() {
        return this._ip;
    }

    @Override
    protected void exec(String script) {
        this._ip.evaluate(script);
    }

    @Override
    protected boolean contains(String name) {
        return this._global.getVariables().containsKey(name);
    }

    @Override
    protected Object get(String name) {
        try {
            return this._global.getVariable(name);
        }
        catch (MissingPropertyException ex) {
            return null;
        }
    }

    @Override
    protected void set(String name, Object value) {
        this._global.setVariable(name, value);
    }

    @Override
    protected void unset(String name) {
        this._global.getVariables().remove(name);
    }

    @Override
    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        this._global = new Binding((Map)new Variables());
        this._ip = new GroovyShell(this._global);
    }

    @Override
    public void destroy() {
        this._ip = null;
        this._global = null;
        super.destroy();
    }

    @Override
    public Function getFunction(String name, Class[] argTypes) {
        Object val = this.get(name);
        if (!(val instanceof Closure)) {
            return null;
        }
        return new ClosureFunction((Closure)val);
    }

    private static class ClosureFunction
    implements Function {
        private final Closure _closure;

        private ClosureFunction(Closure closure) {
            this._closure = closure;
        }

        public Class[] getParameterTypes() {
            return new Class[0];
        }

        public Class getReturnType() {
            return Object.class;
        }

        public Object invoke(Object obj, Object[] args) throws Exception {
            if (args == null) {
                return this._closure.call();
            }
            return this._closure.call(args);
        }

        public Method toMethod() {
            return null;
        }
    }

    private class Variables
    extends HashMap {
        private Variables() {
        }

        @Override
        public Object get(Object key) {
            Object val = super.get(key);
            if (val != null || this.containsKey(key) || !(key instanceof String)) {
                return val;
            }
            val = GroovyInterpreter.this.getFromNamespace((String)key);
            return val != GenericInterpreter.UNDEFINED ? val : null;
        }
    }
}

