/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.base.LookupFactoryHelper;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;
import org.idempiere.util.ParseSeq;

public class GridField
implements Serializable,
Evaluatee,
Cloneable {
    private static final long serialVersionUID = -4496344553246662012L;
    private static final Character SPECIAL_CASE_DEFAULT = Character.valueOf('1');
    private static final Character SQL_DEFAULT = Character.valueOf('2');
    private static final Character DEFAULT_LOGIC = Character.valueOf('3');
    private static final Character USER_PREFERENCE_DEFAULT = Character.valueOf('4');
    private static final Character SYSTEM_PREFERENCE_DEFAULT = Character.valueOf('5');
    private static final Character PANEL_PREFERENCE_DEFAULT = Character.valueOf('6');
    private static final Character DATA_TYPE_DEFAULT = Character.valueOf('7');
    private static final String DEFAULT_PRIORITY_ORDER = "123457";
    private static final String DEFAULT_PRIORITY_ORDER_FOR_PANEL = "623";
    private GridFieldVO m_vo;
    private char m_mnemonic = '\u0000';
    private GridTab m_gridTab;
    private boolean m_lookupEditorSettingValue = false;
    private boolean m_lockedRecord = false;
    private Lookup m_lookup = null;
    private boolean m_inserting = false;
    public static final int MAXDISPLAY_LENGTH = 60;
    private Object m_value = null;
    private static Object s_oldValue = new Object();
    private Object m_oldValue = s_oldValue;
    private boolean m_valueNoFire = true;
    private boolean m_error = false;
    private Boolean m_parentValue = null;
    private PropertyChangeSupport m_propertyChangeListeners = new PropertyChangeSupport(this);
    public static final String PROPERTY = "FieldValue";
    public static final String INSERTING = "FieldValueInserting";
    private String m_errorValue = null;
    private boolean m_errorValueFlag = false;
    private static CLogger log = CLogger.getCLogger(GridField.class);
    private String m_backupValue = null;
    private boolean m_isBackupValue = false;
    private Evaluatee m_parentEvaluatee = null;

    public GridField(GridFieldVO vo) {
        this.m_vo = vo;
        this.loadLookup();
        this.setError(false);
    }

    protected void dispose() {
        this.m_propertyChangeListeners = null;
        if (this.m_lookup != null) {
            this.m_lookup.dispose();
        }
        this.m_lookup = null;
        this.m_vo.lookupInfo = null;
        this.m_vo = null;
    }

    public void loadLookup() {
        if (!this.isLookup()) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("(" + this.m_vo.ColumnName + ")");
        }
        if (DisplayType.isLookup(this.m_vo.displayType)) {
            if (this.m_vo.IsDisplayed) {
                if (this.m_vo.lookupInfo == null) {
                    log.log(Level.SEVERE, "(" + this.m_vo.ColumnName + ") - No LookupInfo");
                    return;
                }
                this.loadLookupNoValidate();
            }
        } else {
            this.loadLookupFromFactory();
        }
    }

    private void loadLookupFromFactory() {
        this.m_lookup = LookupFactoryHelper.getLookup(this.m_vo);
    }

    public void loadLookupNoValidate() {
        if (this.m_vo.lookupInfo == null && this.isLookup()) {
            this.m_vo.loadLookupInfo();
        }
        if (this.m_vo.lookupInfo == null) {
            return;
        }
        if (this.m_vo.displayType == 18 && this.m_vo.AD_Tab_ID > 0 && (this.m_vo.ColumnName.equals("CreatedBy") || this.m_vo.ColumnName.equals("UpdatedBy"))) {
            this.m_vo.lookupInfo.IsCreadedUpdatedBy = true;
            this.m_vo.lookupInfo.DisplayType = 30;
            this.m_vo.displayType = 30;
        }
        this.m_vo.lookupInfo.IsKey = this.isKey();
        this.loadLookupFromFactory();
    }

    public void lookupLoadComplete() {
        if (this.m_lookup == null) {
            return;
        }
        this.m_lookup.loadComplete();
    }

    public Lookup getLookup() {
        if (this.m_lookup == null) {
            this.loadLookupNoValidate();
        }
        return this.m_lookup;
    }

    public boolean isLookup() {
        boolean retValue = false;
        if (DisplayType.isLookup(this.m_vo.displayType)) {
            retValue = true;
        } else if (this.m_vo.IsKey) {
            retValue = false;
        } else if (LookupFactoryHelper.isLookup(this.m_vo)) {
            retValue = true;
        }
        return retValue;
    }

    public boolean refreshLookup() {
        if (this.m_lookup == null) {
            return true;
        }
        if (this.m_lookup.getValidation().length() == 0 && this.m_lookup.isLoaded()) {
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("(" + this.m_vo.ColumnName + ")");
        }
        this.m_lookup.refresh();
        return this.m_lookup.isValidated();
    }

    public ArrayList<String> getDependentOn() {
        ArrayList<String> list = new ArrayList<String>();
        Evaluator.parseDepends(list, this.m_vo.DisplayLogic);
        Evaluator.parseDepends(list, this.m_vo.ReadOnlyLogic);
        Evaluator.parseDepends(list, this.m_vo.MandatoryLogic);
        if (this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0 && this.m_vo.ColumnSQL.startsWith("@SQL=")) {
            Evaluator.parseDepends(list, this.m_vo.ColumnSQL.substring(5));
        }
        if (this.m_lookup != null) {
            Evaluator.parseDepends(list, this.m_lookup.getValidation());
        }
        if (list.size() > 0 && CLogMgt.isLevelFiner()) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                sb.append(list.get(i)).append(" ");
                ++i;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("(" + this.m_vo.ColumnName + ") " + sb.toString());
            }
        }
        return list;
    }

    public void setError(boolean error) {
        this.m_error = error;
    }

    public boolean isError() {
        return this.m_error;
    }

    public boolean isMandatory(boolean checkContext) {
        if (checkContext && this.m_vo.MandatoryLogic.length() > 0) {
            boolean retValue = false;
            retValue = this.m_vo.MandatoryLogic != null && this.m_vo.MandatoryLogic.startsWith("@SQL=") ? Evaluator.parseSQLLogic(this.m_vo.MandatoryLogic, this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName) : Evaluator.evaluateLogic(this, this.m_vo.MandatoryLogic);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.m_vo.ColumnName + " Mandatory(" + this.m_vo.MandatoryLogic + ") => Mandatory-" + retValue);
            }
            if (retValue) {
                return true;
            }
        }
        if (!this.m_vo.IsMandatory || this.isVirtualColumn()) {
            return false;
        }
        if (this.m_gridTab != null && (this.m_vo.IsKey && this.m_vo.ColumnName.endsWith("_ID") || this.m_vo.ColumnName.startsWith("Created") || this.m_vo.ColumnName.startsWith("Updated") || this.m_vo.ColumnName.equals("Value") || this.m_vo.ColumnName.equals("DocumentNo") || this.m_vo.ColumnName.equals("M_AttributeSetInstance_ID"))) {
            return false;
        }
        return this.isDisplayed(checkContext);
    }

    public boolean isEditablePara(boolean checkContext) {
        if (checkContext && this.m_vo.ReadOnlyLogic.length() > 0) {
            if (this.m_vo.ReadOnlyLogic.startsWith("@SQL=")) {
                boolean retValue;
                boolean bl = retValue = !Evaluator.parseSQLLogic(this.m_vo.ReadOnlyLogic, this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName);
                if (!retValue) {
                    return false;
                }
            } else {
                boolean retValue;
                boolean bl = retValue = !Evaluator.evaluateLogic(this, this.m_vo.ReadOnlyLogic);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this.m_vo.ColumnName + " R/O(" + this.m_vo.ReadOnlyLogic + ") => R/W-" + retValue);
                }
                if (!retValue) {
                    return false;
                }
            }
        }
        return this.isDisplayed(checkContext);
    }

    public boolean isEditable(boolean checkContext) {
        return this.isEditable(this.m_vo.ctx, checkContext, false);
    }

    public boolean isEditableGrid(boolean checkContext) {
        return this.isEditable(this.m_vo.ctx, checkContext, true);
    }

    public boolean isEditable(final Properties ctx, boolean checkContext, boolean isGrid) {
        if (this.isVirtualColumn()) {
            return false;
        }
        if (this.m_lockedRecord) {
            return false;
        }
        if (this.m_vo.ColumnName.equals("Posted") || this.m_vo.ColumnName.equals("Record_ID") && this.m_vo.displayType == 28) {
            return true;
        }
        if (this.m_vo.tabReadOnly || this.m_vo.IsReadOnly) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.m_vo.ColumnName + " NO - TabRO=" + this.m_vo.tabReadOnly + ", FieldRO=" + this.m_vo.IsReadOnly);
            }
            return false;
        }
        if (this.m_vo.IsAlwaysUpdateable) {
            return true;
        }
        if (checkContext && this.m_vo.AlwaysUpdatableLogic.length() > 0) {
            boolean isAlwaysUpdatable = false;
            if (this.m_vo.AlwaysUpdatableLogic.startsWith("@SQL=")) {
                isAlwaysUpdatable = Evaluator.parseSQLLogic(this.m_vo.AlwaysUpdatableLogic, ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName);
            } else {
                Evaluatee evaluatee = new Evaluatee(){

                    @Override
                    public String get_ValueAsString(String variableName) {
                        return GridField.this.get_ValueAsString(ctx, variableName);
                    }
                };
                isAlwaysUpdatable = Evaluator.evaluateLogic(evaluatee, this.m_vo.AlwaysUpdatableLogic);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this.m_vo.ColumnName + " R/O(" + this.m_vo.AlwaysUpdatableLogic + ") => R/W-" + isAlwaysUpdatable);
                }
            }
            if (isAlwaysUpdatable) {
                return true;
            }
        }
        if (checkContext && this.getGridTab() != null && !"Y".equals(Env.getContext(Env.getCtx(), this.getWindowNo(), "_QUICK_ENTRY_MODE_")) && this.getGridTab().isReadOnly()) {
            return false;
        }
        if (!this.m_vo.IsUpdateable && !this.m_inserting) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.m_vo.ColumnName + " NO - FieldUpdateable=" + this.m_vo.IsUpdateable);
            }
            return false;
        }
        if (this.m_vo.ColumnName.equals(Env.getContext(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_LinkColumnName"))) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.m_vo.ColumnName + " NO - LinkColumn");
            }
            return false;
        }
        if (checkContext) {
            int AD_Client_ID = Env.getContextAsInt(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "AD_Client_ID");
            int AD_Org_ID = Env.getContextAsInt(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "AD_Org_ID");
            Object keyColumn = Env.getContext(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_KeyColumnName");
            if ("EntityType".equals(keyColumn)) {
                keyColumn = "AD_EntityType_ID";
            }
            if (!((String)keyColumn).endsWith("_ID")) {
                keyColumn = (String)keyColumn + "_ID";
            }
            if (this.getGridTab() != null) {
                Boolean access;
                int Record_ID = Env.getContextAsInt(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, (String)keyColumn);
                int AD_Table_ID = this.m_vo.AD_Table_ID;
                if (!MRole.getDefault(ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, AD_Table_ID, Record_ID, false)) {
                    return false;
                }
                if (!MRole.getDefault(ctx, false).isColumnAccess(AD_Table_ID, this.m_vo.AD_Column_ID, false)) {
                    return false;
                }
                if (this.getDisplayType() == 28 && (this.getAD_Process_ID() > 0 ? (access = MRole.getDefault().getProcessAccess(this.getAD_Process_ID())) == null || access == false : this.getAD_InfoWindow_ID() > 0 && ((access = MRole.getDefault().getInfoAccess(this.getAD_InfoWindow_ID())) == null || access == false))) {
                    return false;
                }
            }
        }
        if (checkContext && this.m_vo.ReadOnlyLogic.length() > 0) {
            if (this.m_vo.ReadOnlyLogic.startsWith("@SQL=")) {
                boolean retValue;
                boolean bl = retValue = !Evaluator.parseSQLLogic(this.m_vo.ReadOnlyLogic, ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName);
                if (!retValue) {
                    return false;
                }
            } else {
                boolean retValue;
                Evaluatee evaluatee = new Evaluatee(){

                    @Override
                    public String get_ValueAsString(String variableName) {
                        return GridField.this.get_ValueAsString(ctx, variableName);
                    }
                };
                boolean bl = retValue = !Evaluator.evaluateLogic(evaluatee, this.m_vo.ReadOnlyLogic);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this.m_vo.ColumnName + " R/O(" + this.m_vo.ReadOnlyLogic + ") => R/W-" + retValue);
                }
                if (!retValue) {
                    return false;
                }
            }
        }
        if (checkContext && "Y".equals(Env.getContext(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "IsActive")) && (this.m_vo.ColumnName.equals("Processing") || this.m_vo.ColumnName.equals("DocAction") || this.m_vo.ColumnName.equals("GenerateTo"))) {
            return true;
        }
        if (checkContext && ("Y".equals(this.get_ValueAsString("Processed")) || "Y".equals(this.get_ValueAsString("Processing")))) {
            return false;
        }
        if (this.m_vo.ColumnName.equals("IsActive")) {
            return true;
        }
        if (checkContext && this.getGridTab() != null && !Env.getContext(ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "IsActive").equals("Y")) {
            return false;
        }
        return this.isDisplayed(ctx, checkContext);
    }

    public void setInserting(boolean inserting) {
        this.m_inserting = inserting;
    }

    public void setDefaultLogic(String defaultValue) {
        this.m_vo.DefaultValue = defaultValue;
    }

    public void setDefault2Logic(String defaultValue2) {
        this.m_vo.DefaultValue2 = defaultValue2;
    }

    public Object getDefault() {
        if (this.isIgnoreDefault()) {
            return null;
        }
        Object defaultValue = null;
        defaultValue = this.getDefault(DEFAULT_PRIORITY_ORDER);
        if (defaultValue != null) {
            return defaultValue;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("[NONE] " + this.m_vo.ColumnName);
        }
        return null;
    }

    public Object getDefaultForPanel() {
        return this.getDefault(MSysConfig.getValue("ZK_SEQ_DEFAULT_VALUE_PANEL", DEFAULT_PRIORITY_ORDER_FOR_PANEL, Env.getAD_Client_ID(this.m_vo.ctx)));
    }

    public Object getDefault(String seqGetDefaultValueStr) {
        ParseSeq seqGetDefaultValue = ParseSeq.getNumberOrder(seqGetDefaultValueStr);
        if (seqGetDefaultValue == null) {
            throw new AdempiereException("seq define for get default value has wrong value");
        }
        return this.getDefault(seqGetDefaultValue);
    }

    public Object getDefault(ParseSeq seqGetDefaultValue) {
        Object defaultValue = null;
        for (Character seqType : seqGetDefaultValue) {
            if (seqType == DEFAULT_LOGIC && this.m_vo.DefaultValue != null && this.m_vo.DefaultValue.toUpperCase().equals("NULL")) {
                return null;
            }
            defaultValue = this.getDefaultValueByType(seqType);
            if (defaultValue == null) continue;
            return defaultValue;
        }
        return defaultValue;
    }

    protected Object getDefaultValueByType(Character defaultValueType) {
        if (defaultValueType.equals(SPECIAL_CASE_DEFAULT)) {
            return this.defaultForSpecialCase();
        }
        if (defaultValueType.equals(SQL_DEFAULT)) {
            return this.defaultFromSQLExpression();
        }
        if (defaultValueType.equals(DEFAULT_LOGIC)) {
            return this.defaultFromExpression();
        }
        if (defaultValueType.equals(USER_PREFERENCE_DEFAULT) || defaultValueType.equals(SYSTEM_PREFERENCE_DEFAULT)) {
            return this.defaultFromPreference(defaultValueType);
        }
        if (defaultValueType.equals(PANEL_PREFERENCE_DEFAULT)) {
            return this.defaultFromPreferenceForPanel();
        }
        if (defaultValueType.equals(DATA_TYPE_DEFAULT)) {
            return this.defaultFromDatatype();
        }
        return null;
    }

    protected boolean isIgnoreDefault() {
        return this.m_vo.IsKey || this.m_vo.displayType == 26 || DisplayType.isLOB(this.m_vo.displayType) || "Created".equals(this.m_vo.ColumnName) || "Updated".equals(this.m_vo.ColumnName);
    }

    protected Object defaultForSpecialCase() {
        Object defaultValue = null;
        defaultValue = this.defaultFromParent();
        if (defaultValue != null) {
            return defaultValue;
        }
        defaultValue = this.defaultForActiveField();
        if (defaultValue != null) {
            return defaultValue;
        }
        defaultValue = this.defaultForClientOrg();
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    protected Object defaultFromParent() {
        if (this.isParentValue() && (this.m_vo.DefaultValue == null || this.m_vo.DefaultValue.length() == 0)) {
            String parent = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName);
            if (log.isLoggable(Level.FINE)) {
                log.fine("[Parent] " + this.m_vo.ColumnName + "=" + parent);
            }
            return this.createDefault(parent);
        }
        return null;
    }

    protected Object defaultForActiveField() {
        if (this.m_vo.ColumnName.equals("IsActive")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[IsActive] " + this.m_vo.ColumnName + "=Y");
            }
            return "Y";
        }
        return null;
    }

    protected Object defaultForClientOrg() {
        if ("4".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_AccessLevel")) && (this.m_vo.ColumnName.equals("AD_Client_ID") || this.m_vo.ColumnName.equals("AD_Org_ID"))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[SystemAccess] " + this.m_vo.ColumnName + "=0");
            }
            return 0;
        }
        if ("6".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_AccessLevel")) && this.m_vo.ColumnName.equals("AD_Org_ID")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[ClientAccess] " + this.m_vo.ColumnName + "=0");
            }
            return 0;
        }
        return null;
    }

    protected Object defaultFromSQLExpression() {
        String defStr = "";
        if (this.m_vo.DefaultValue != null && this.m_vo.DefaultValue.startsWith("@SQL=")) {
            block13: {
                String sql = this.m_vo.DefaultValue.substring(5);
                if ((sql = Env.parseContext(this.m_vo.ctx, this.m_vo.WindowNo, sql, false, false)).equals("")) {
                    log.log(Level.WARNING, "(" + this.m_vo.ColumnName + ") - Default SQL variable parse failed: " + this.m_vo.DefaultValue);
                } else {
                    CPreparedStatement stmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            String trxName = this.m_gridTab != null ? this.m_gridTab.getTableModel().get_TrxName() : null;
                            stmt = DB.prepareStatement(sql, trxName);
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                defStr = rs.getString(1);
                            } else if (log.isLoggable(Level.INFO)) {
                                log.log(Level.INFO, "(" + this.m_vo.ColumnName + ") - no Result: " + sql);
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.WARNING, "(" + this.m_vo.ColumnName + ") " + sql, e);
                            DB.close(rs, stmt);
                            rs = null;
                            stmt = null;
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                    DB.close(rs, stmt);
                    rs = null;
                    Object var3_3 = null;
                }
            }
            if (defStr != null && defStr.length() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("[SQL] " + this.m_vo.ColumnName + "=" + defStr);
                }
                return this.createDefault(defStr);
            }
        }
        return null;
    }

    protected Object defaultFromExpression() {
        if (this.m_vo.DefaultValue != null && !this.m_vo.DefaultValue.equals("") && !this.m_vo.DefaultValue.startsWith("@SQL=")) {
            String defStr = "";
            StringTokenizer st = new StringTokenizer(this.m_vo.DefaultValue, ",;", false);
            while (st.hasMoreTokens()) {
                defStr = st.nextToken().trim();
                if (defStr.equals("@SysDate@")) {
                    return new Timestamp(System.currentTimeMillis());
                }
                if (defStr.indexOf(64) != -1) {
                    defStr = Env.parseContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, defStr.trim(), false, false);
                } else if (defStr.indexOf("'") != -1) {
                    defStr = defStr.replace('\'', ' ').trim();
                }
                if (defStr.equals("")) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("[DefaultValue] " + this.m_vo.ColumnName + "=" + defStr);
                }
                return this.createDefault(defStr);
            }
        }
        return null;
    }

    protected Object defaultFromPreferenceForPanel() {
        String defStr = "";
        if (this.getAD_Process_ID_Of_Panel() > 0) {
            defStr = Env.getPreference(this.m_vo.ctx, this.getAD_Window_ID_Of_Panel(), this.getAD_InfoWindow_ID_of_Panel(), this.getAD_Process_ID_Of_Panel(), this.m_vo.ColumnName);
            if (defStr.equals("") && this.getAD_InfoWindow_ID_of_Panel() > 0) {
                defStr = Env.getPreference(this.m_vo.ctx, Env.adWindowDummyID, this.getAD_InfoWindow_ID_of_Panel(), 0, this.m_vo.ColumnName);
                if (defStr.equals("")) {
                    defStr = Env.getPreference(this.m_vo.ctx, Env.adWindowDummyID, 0, this.getAD_Process_ID_Of_Panel(), this.m_vo.ColumnName);
                }
                if (defStr.equals("")) {
                    defStr = Env.getPreference(this.m_vo.ctx, Env.adWindowDummyID, 0, 0, this.m_vo.ColumnName);
                }
            }
            if (defStr.equals("")) {
                defStr = Env.getPreference(this.m_vo.ctx, this.getAD_Window_ID_Of_Panel(), 0, 0, this.m_vo.ColumnName);
            }
            if (defStr.equals("")) {
                defStr = Env.getPreference(this.m_vo.ctx, 0, 0, this.getAD_Process_ID_Of_Panel(), this.m_vo.ColumnName);
            }
            if (defStr.equals("")) {
                defStr = Env.getPreference(this.m_vo.ctx, 0, 0, 0, this.m_vo.ColumnName);
            }
            if (!defStr.equals("")) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("[Process Parameter Preference] " + this.m_vo.ColumnName + "=" + defStr);
                }
                return this.createDefault(defStr);
            }
        } else if (this.getAD_InfoWindow_ID_of_Panel() > 0 && !(defStr = Env.getPreference(this.m_vo.ctx, this.getAD_Window_ID_Of_Panel(), this.getAD_InfoWindow_ID_of_Panel(), this.m_vo.ColumnName)).equals("")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[Process Parameter Preference] " + this.m_vo.ColumnName + "=" + defStr);
            }
            return this.createDefault(defStr);
        }
        return null;
    }

    protected Object defaultFromPreference(Character defaultValueType) {
        String defStr = "";
        if (defaultValueType.equals(Character.valueOf('4'))) {
            defStr = Env.getPreference(this.m_vo.ctx, this.m_vo.AD_Window_ID, this.m_vo.ColumnName, false);
            if (!defStr.equals("")) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("[UserPreference] " + this.m_vo.ColumnName + "=" + defStr);
                }
                return this.createDefault(defStr);
            }
        } else if (defaultValueType.equals(Character.valueOf('5')) && !(defStr = Env.getPreference(this.m_vo.ctx, this.m_vo.AD_Window_ID, this.m_vo.ColumnName, true)).equals("")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[SystemPreference] " + this.m_vo.ColumnName + "=" + defStr);
            }
            return this.createDefault(defStr);
        }
        return null;
    }

    protected Object defaultFromDatatype() {
        if (this.m_vo.displayType == 28 && !this.m_vo.ColumnName.endsWith("_ID")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[Button=N] " + this.m_vo.ColumnName);
            }
            return "N";
        }
        if (this.m_vo.displayType == 20) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[YesNo=N] " + this.m_vo.ColumnName);
            }
            return "N";
        }
        if (this.m_vo.ColumnName.endsWith("_ID")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[ID=null] " + this.m_vo.ColumnName);
            }
            return null;
        }
        if (DisplayType.isNumeric(this.m_vo.displayType)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[Number=0] " + this.m_vo.ColumnName);
            }
            return this.createDefault("0");
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Object createDefault(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean validateValueNoDirect() {
        String name;
        this.refreshLookup();
        if (this.m_value == null || this.m_value.toString().length() == 0) {
            if (this.isMandatory(true)) {
                this.m_error = true;
                return false;
            }
            return true;
        }
        if (this.getDisplayType() == 30 && this.m_lookup != null) {
            if (this.m_lookup.getDirect(this.m_value, false, true) == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this.m_vo.ColumnName + " Search not valid - set to null");
                }
                this.setValue(null, this.m_inserting);
                this.m_error = true;
                return false;
            }
            return true;
        }
        if (!this.isLookup() || this.m_lookup == null) {
            return true;
        }
        if (this.getDisplayType() == 200161) {
            boolean allValid = true;
            String[] stringArray = ((String)this.m_value).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String vals = stringArray[n2];
                if (!this.m_lookup.containsKeyNoDirect(vals)) {
                    if (this.m_lookup.get(vals) == null) {
                        allValid = false;
                        break;
                    }
                    String name2 = this.m_lookup.get(vals).getName();
                    if (name2.startsWith("~") && name2.endsWith("~")) {
                        allValid = false;
                        break;
                    }
                }
                ++n2;
            }
            if (allValid) {
                return true;
            }
        } else if (DisplayType.isMultiID(this.getDisplayType())) {
            boolean allValid = true;
            String[] stringArray = ((String)this.m_value).split(",");
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String vals = stringArray[n3];
                Integer vali = Integer.valueOf(vals);
                if (!this.m_lookup.containsKeyNoDirect(vali)) {
                    if (this.m_lookup.get(vali) == null) {
                        allValid = false;
                        break;
                    }
                    String name3 = this.m_lookup.get(vali).getName();
                    if (name3.startsWith("~") && name3.endsWith("~")) {
                        allValid = false;
                        break;
                    }
                }
                ++n3;
            }
            if (allValid) {
                return true;
            }
        } else if (!(!this.m_lookup.containsKeyNoDirect(this.m_value) || (name = this.m_lookup.get(this.m_value).getName()).startsWith("~") && name.endsWith("~"))) {
            return true;
        }
        if (this.isKey() || this.isParentValue()) {
            return true;
        }
        if ("AD_Client_ID".equals(this.m_vo.ColumnName) && "0".equals(this.m_value.toString()) && Env.getAD_Client_ID(Env.getCtx()) == 0) {
            return true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.m_vo.ColumnName + " - set to null");
        }
        this.setValue(null, this.m_inserting);
        this.m_error = true;
        return false;
    }

    public boolean validateValue() {
        if (this.m_value == null || this.m_value.toString().length() == 0) {
            if (this.isMandatory(true)) {
                this.m_error = true;
                return false;
            }
            return true;
        }
        if (this.getDisplayType() == 30 && this.m_lookup != null) {
            if (this.m_lookup.getDirect(this.m_value, false, true) == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this.m_vo.ColumnName + " Search not valid - set to null");
                }
                this.setValue(null, this.m_inserting);
                this.m_error = true;
                return false;
            }
            return true;
        }
        if (!this.isLookup() || this.m_lookup == null || this.m_lookup.containsKey(this.m_value)) {
            return true;
        }
        if (this.isKey() || this.isParentValue()) {
            return true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.m_vo.ColumnName + " - set to null");
        }
        this.setValue(null, this.m_inserting);
        this.m_error = true;
        return false;
    }

    public boolean isDisplayed(boolean checkContext) {
        return this.isDisplayed(this.m_vo.ctx, checkContext);
    }

    public boolean isDisplayed(final Properties ctx, boolean checkContext) {
        if (!this.m_vo.IsDisplayed) {
            return false;
        }
        if (this.m_vo.DisplayLogic.equals("")) {
            return true;
        }
        if (checkContext) {
            if (this.m_vo.DisplayLogic.startsWith("@SQL=")) {
                return Evaluator.parseSQLLogic(this.m_vo.DisplayLogic, this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName);
            }
            Evaluatee evaluatee = new Evaluatee(){

                @Override
                public String get_ValueAsString(String variableName) {
                    return GridField.this.get_ValueAsString(ctx, variableName);
                }
            };
            boolean retValue = Evaluator.evaluateLogic(evaluatee, this.m_vo.DisplayLogic);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.m_vo.ColumnName + " (" + this.m_vo.DisplayLogic + ") => " + retValue);
            }
            return retValue;
        }
        return true;
    }

    public boolean isDisplayedGrid(boolean checkContext) {
        return this.isDisplayedGrid(this.m_vo.ctx, checkContext);
    }

    public boolean isDisplayedGrid(final Properties ctx, boolean checkContext) {
        if (!this.m_vo.IsDisplayedGrid && !this.m_vo.IsDisplayed) {
            return false;
        }
        if (this.m_vo.DisplayLogic.equals("")) {
            return true;
        }
        if (checkContext) {
            if (this.m_vo.DisplayLogic.startsWith("@SQL=")) {
                return Evaluator.parseSQLLogic(this.m_vo.DisplayLogic, ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName);
            }
            Evaluatee evaluatee = new Evaluatee(){

                @Override
                public String get_ValueAsString(String variableName) {
                    return GridField.this.get_ValueAsString(ctx, variableName);
                }
            };
            boolean retValue = Evaluator.evaluateLogic(evaluatee, this.m_vo.DisplayLogic);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.m_vo.ColumnName + " (" + this.m_vo.DisplayLogic + ") => " + retValue);
            }
            return retValue;
        }
        return true;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return this.get_ValueAsString(this.m_vo.ctx, variableName);
    }

    public String get_ValueAsString(Properties ctx, String variableName) {
        String value;
        if (this.m_parentEvaluatee != null && (value = this.m_parentEvaluatee.get_ValueAsString(variableName)) != null) {
            return value;
        }
        return new DefaultEvaluatee(this.getGridTab(), this.m_vo.WindowNo, this.m_vo.TabNo).get_ValueAsString(ctx, variableName);
    }

    public void addDependencies(ArrayList<String> list) {
        if (!this.m_vo.IsDisplayed || this.m_vo.DisplayLogic.equals("")) {
            return;
        }
        StringTokenizer logic = new StringTokenizer(this.m_vo.DisplayLogic.trim(), "&|", false);
        while (logic.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(logic.nextToken().trim(), "!=^", false);
            while (st.hasMoreTokens()) {
                String tag = st.nextToken().trim();
                if (tag.indexOf(64) == -1 || list.contains(tag = tag.replace('@', ' ').trim())) continue;
                list.add(tag);
            }
        }
    }

    public String getColumnName() {
        return this.m_vo.ColumnName;
    }

    public String getColumnSQL(boolean withAS) {
        if (this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0) {
            String query = this.m_vo.ColumnSQL.startsWith("@SQL=") || this.m_vo.ColumnSQL.startsWith("@SQLFIND=") ? "NULL" : this.m_vo.ColumnSQL;
            if (withAS) {
                return query + " AS " + this.m_vo.ColumnName;
            }
            return query;
        }
        return this.m_vo.ColumnName;
    }

    public String getSearchColumnSQL() {
        if (this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0) {
            String query = this.m_vo.ColumnSQL.startsWith("@SQL=") ? "NULL" : (this.m_vo.ColumnSQL.startsWith("@SQLFIND=") ? this.m_vo.ColumnSQL.substring(9) : this.m_vo.ColumnSQL);
            return query;
        }
        return this.m_vo.ColumnName;
    }

    public boolean isVirtualColumn() {
        return this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0;
    }

    public boolean isVirtualDBColumn() {
        return this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0 && !this.m_vo.ColumnSQL.startsWith("@SQL=");
    }

    public boolean isVirtualUIColumn() {
        return this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0 && this.m_vo.ColumnSQL.startsWith("@SQL=");
    }

    public boolean isVirtualSearchColumn() {
        return this.m_vo.ColumnSQL != null && this.m_vo.ColumnSQL.length() > 0 && this.m_vo.ColumnSQL.startsWith("@SQLFIND=");
    }

    public String getHeader() {
        return this.m_vo.Header;
    }

    public int getDisplayType() {
        return this.m_vo.displayType;
    }

    public int getAD_Reference_Value_ID() {
        return this.m_vo.AD_Reference_Value_ID;
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getAD_Process_ID_Of_Panel() {
        return this.m_vo.AD_Process_ID_Of_Panel;
    }

    public int getAD_Window_ID_Of_Panel() {
        return this.m_vo.AD_Window_ID_Of_Panel > 0 ? this.m_vo.AD_Window_ID_Of_Panel : this.m_vo.AD_Window_ID;
    }

    public int getAD_InfoWindow_ID_of_Panel() {
        return this.m_vo.AD_InfoWindow_ID_Of_Panel;
    }

    public int getAD_Chart_ID() {
        return this.m_vo.AD_Chart_ID;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public int getAD_Column_ID() {
        return this.m_vo.AD_Column_ID;
    }

    public int getDisplayLength() {
        return this.m_vo.DisplayLength;
    }

    public boolean isSameLine() {
        return this.m_vo.IsSameLine;
    }

    public boolean isDisplayed() {
        return this.m_vo.IsDisplayed;
    }

    public boolean isDisplayedGrid() {
        return this.m_vo.IsDisplayedGrid;
    }

    public int getSeqNoGrid() {
        return this.m_vo.SeqNoGrid;
    }

    public String getDisplayLogic() {
        return this.m_vo.DisplayLogic;
    }

    public String getDefaultValue() {
        return this.m_vo.DefaultValue;
    }

    public boolean isReadOnly() {
        if (this.isVirtualColumn()) {
            return true;
        }
        return this.m_vo.IsReadOnly;
    }

    public boolean isUpdateable() {
        if (this.isVirtualColumn()) {
            return false;
        }
        return this.m_vo.IsUpdateable;
    }

    public boolean isAutocomplete() {
        return this.m_vo.IsAutocomplete;
    }

    public boolean isAllowCopy() {
        String colname = this.getColumnName();
        if (colname.equals("C_CashLine_ID") || colname.equals("C_Location_ID") || colname.equals("C_Payment_ID") || colname.equals("DocAction") || colname.equals("DocStatus") || colname.equals("DocumentNo") || colname.equals("EntityType") || colname.equals("GrandTotal") || colname.equals("IsAllocated") || colname.equals("IsApproved") || colname.equals("IsDelivered") || colname.equals("IsGenerated") || colname.equals("IsInvoiced") || colname.equals("IsPaid") || colname.equals("IsReconciled") || colname.equals("IsSelfService") || colname.equals("Line") || colname.equals("Posted") || colname.equals("Processed") || colname.equals("ProcessedOn") || colname.equals("TotalCr") || colname.equals("TotalDr") || colname.equals("TotalLines") || colname.startsWith("Ref_")) {
            return false;
        }
        return this.m_vo.IsAllowCopy;
    }

    public boolean isAlwaysUpdateable() {
        if (this.isVirtualColumn() || !this.m_vo.IsUpdateable) {
            return false;
        }
        return this.m_vo.IsAlwaysUpdateable;
    }

    public boolean isHeading() {
        return this.m_vo.IsHeading;
    }

    public boolean isFieldOnly() {
        return this.m_vo.IsFieldOnly;
    }

    public boolean isEncryptedField() {
        return this.m_vo.IsEncryptedField;
    }

    public boolean isEncrypted() {
        if (this.m_vo.IsEncryptedField) {
            return true;
        }
        String ob = this.getObscureType();
        if (ob != null && ob.length() > 0) {
            return true;
        }
        return this.m_vo.ColumnName.equals("Password");
    }

    public boolean isEncryptedColumn() {
        return this.m_vo.IsEncryptedColumn;
    }

    public boolean isSelectionColumn() {
        return this.m_vo.IsSelectionColumn;
    }

    public boolean isHtml() {
        return this.m_vo.IsHtml;
    }

    public int getSeqNoSelection() {
        return this.m_vo.SeqNoSelection;
    }

    public String getObscureType() {
        return this.m_vo.ObscureType;
    }

    public int getSortNo() {
        return this.m_vo.SortNo;
    }

    public int getFieldLength() {
        return this.m_vo.FieldLength;
    }

    public String getVFormat() {
        return this.m_vo.VFormat;
    }

    public String getFormatPattern() {
        return this.m_vo.FormatPattern;
    }

    public String getValueMin() {
        return this.m_vo.ValueMin;
    }

    public String getValueMax() {
        return this.m_vo.ValueMax;
    }

    public String getFieldGroup() {
        return this.m_vo.FieldGroup;
    }

    public String getFieldGroupType() {
        return this.m_vo.FieldGroupType;
    }

    public boolean isKey() {
        return this.m_vo.IsKey;
    }

    public boolean isUUID() {
        return this.getGridTab() != null && this.m_vo.ColumnName.equals(PO.getUUIDColumnName(this.getGridTab().getTableName()));
    }

    public boolean isParentColumn() {
        return this.m_vo.IsParent;
    }

    public boolean isParentValue() {
        if (this.m_parentValue != null) {
            return this.m_parentValue;
        }
        if (!DisplayType.isID(this.m_vo.displayType) && !DisplayType.isUUID(this.m_vo.displayType) || this.m_vo.TabNo == 0) {
            this.m_parentValue = Boolean.FALSE;
        } else {
            String LinkColumnName = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, "_TabInfo_LinkColumnName");
            this.m_parentValue = LinkColumnName == null || LinkColumnName.length() == 0 ? Boolean.FALSE : Boolean.valueOf(this.m_vo.ColumnName.equals(LinkColumnName));
            if (this.m_parentValue.booleanValue()) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(String.valueOf(this.m_parentValue) + " - Link(" + LinkColumnName + ", W=" + this.m_vo.WindowNo + ",T=" + this.m_vo.TabNo + ") = " + this.m_vo.ColumnName);
                }
            } else {
                this.m_parentValue = this.isIndirectParentValue();
            }
        }
        return this.m_parentValue;
    }

    public String getCallout() {
        return this.m_vo.Callout;
    }

    public int getAD_Process_ID() {
        return this.m_vo.AD_Process_ID;
    }

    public int getAD_InfoWindow_ID() {
        return this.m_vo.AD_InfoWindow_ID;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public int getAD_Tab_ID() {
        return this.m_vo.AD_Tab_ID;
    }

    public GridFieldVO getVO() {
        return this.m_vo;
    }

    public boolean isDefaultFocus() {
        return this.m_vo.IsDefaultFocus;
    }

    public boolean isLongField() {
        return this.m_vo.DisplayLength >= 30;
    }

    public int getAD_Field_ID() {
        return this.m_vo.AD_Field_ID;
    }

    public void setValue() {
        if (this.m_valueNoFire) {
            this.m_oldValue = this.m_value;
        }
        this.m_value = null;
        this.m_inserting = false;
        this.m_error = false;
        this.m_propertyChangeListeners.firePropertyChange(PROPERTY, this.m_oldValue, this.m_value);
    }

    public void setValueAndUpdateContext() {
        if (this.m_valueNoFire) {
            this.m_oldValue = this.m_value;
        }
        this.m_value = null;
        this.m_inserting = false;
        this.m_error = false;
        Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, (String)this.m_value);
        this.m_propertyChangeListeners.firePropertyChange(PROPERTY, this.m_oldValue, this.m_value);
    }

    public void setValue(Object newValue, boolean inserting) {
        if (this.m_valueNoFire) {
            this.m_oldValue = this.m_value;
        }
        this.m_value = newValue;
        this.m_inserting = inserting;
        this.m_error = false;
        this.updateContext();
        Object oldValue = this.m_oldValue;
        if (inserting) {
            oldValue = INSERTING;
        }
        this.m_propertyChangeListeners.firePropertyChange(PROPERTY, oldValue, this.m_value);
    }

    public void updateContext() {
        if (this.m_vo.displayType != 14 && this.m_vo.displayType != 34 && this.m_vo.displayType != 36 && this.m_vo.displayType != 200267 && this.m_vo.displayType != 23 && this.m_vo.displayType != 26 && !this.isEncrypted()) {
            if (this.m_value instanceof Boolean) {
                this.backupValue();
                if (!this.isParentTabField() && this.isUpdateWindowContext()) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, (Boolean)this.m_value);
                }
                if (this.m_gridTab != null) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, this.m_value == null ? null : ((Boolean)this.m_value != false ? "Y" : "N"));
                }
            } else if (this.m_value instanceof Timestamp) {
                this.backupValue();
                if (!this.isParentTabField() && this.isUpdateWindowContext()) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, (Timestamp)this.m_value);
                }
                String stringValue = null;
                if (this.m_value != null && !this.m_value.toString().equals("")) {
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime((Date)this.m_value);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    stringValue = sdf.format(c1.getTime());
                }
                if (this.m_gridTab != null) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, stringValue);
                }
            } else {
                this.backupValue();
                if (!this.isParentTabField() && this.isUpdateWindowContext()) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, this.m_value == null ? null : this.m_value.toString());
                }
                if (this.m_gridTab != null) {
                    Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, this.m_value == null ? null : this.m_value.toString());
                }
            }
        }
    }

    public int getAD_LabelStyle_ID() {
        return this.m_vo.AD_LabelStyle_ID;
    }

    public int getAD_FieldStyle_ID() {
        return this.m_vo.AD_FieldStyle_ID;
    }

    public String setValueValidate(String newValue, boolean inserting) {
        int dt;
        block14: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            if (newValue == null) {
                                this.setValue();
                            }
                            dt = this.getDisplayType();
                            try {
                                if (dt == 11 || DisplayType.isID(dt) && this.getColumnName().endsWith("_ID")) {
                                    int i = Integer.parseInt(newValue);
                                    this.setValue(i, inserting);
                                    break block14;
                                }
                                if (!DisplayType.isNumeric(dt)) break block15;
                                BigDecimal value = (BigDecimal)DisplayType.getNumberFormat(dt).parse(newValue);
                                this.setValue(value, inserting);
                                return null;
                            }
                            catch (Exception ex) {
                                log.log(Level.SEVERE, "Value=" + newValue, ex);
                                String error = ex.getLocalizedMessage();
                                if (error == null || error.length() == 0) {
                                    error = ex.toString();
                                }
                                return this.getColumnName() + " = " + newValue + " - " + error;
                            }
                        }
                        if (!DisplayType.isDate(dt)) break block16;
                        long time = DisplayType.getDateFormat_JDBC().parse(newValue).getTime();
                        this.setValue(new Timestamp(time), inserting);
                        return null;
                    }
                    if (dt != 20) break block17;
                    Boolean value = null;
                    if (newValue.equals("Y")) {
                        value = Boolean.TRUE;
                    } else if (newValue.equals("N")) {
                        value = Boolean.FALSE;
                    } else {
                        return this.getColumnName() + " = " + newValue + " - Must be Y/N";
                    }
                    this.setValue(value, inserting);
                    return null;
                }
                if (!DisplayType.isText(dt)) break block18;
                this.setValue(newValue, inserting);
                return null;
            }
            return this.getColumnName() + " not mapped " + DisplayType.getDescription(dt);
        }
        if (!DisplayType.isID(dt)) {
            return null;
        }
        return null;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValueNoFire(boolean value) {
        this.m_valueNoFire = value;
    }

    public Object getOldValue() {
        return this.m_oldValue;
    }

    public void setErrorValue(String errorValue) {
        this.m_errorValue = errorValue;
        this.m_errorValueFlag = true;
    }

    public String getErrorValue() {
        String s = this.m_errorValue;
        this.m_errorValue = null;
        this.m_errorValueFlag = false;
        return s;
    }

    public boolean isErrorValue() {
        boolean b2 = this.m_errorValueFlag;
        this.m_errorValueFlag = false;
        return b2;
    }

    public void setDisplayLength(int length) {
        this.m_vo.DisplayLength = length;
    }

    public void setDisplayed(boolean displayed) {
        this.m_vo.IsDisplayed = displayed;
    }

    public boolean isCreateMnemonic() {
        return !this.isReadOnly() && !this.m_vo.ColumnName.equals("AD_Client_ID") && !this.m_vo.ColumnName.equals("AD_Org_ID") && !this.m_vo.ColumnName.equals("DocumentNo");
    }

    public char getMnemonic() {
        return this.m_mnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.m_mnemonic = mnemonic;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GridField[").append(this.m_vo.ColumnName).append("=").append(this.m_value);
        if (this.isKey()) {
            sb.append("(Key)");
        }
        if (this.isParentColumn()) {
            sb.append("(Parent)");
        }
        sb.append(", IsDisplayed=" + this.m_vo.IsDisplayed);
        sb.append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("GridField[");
        sb.append(this.m_vo.ColumnName).append("=").append(this.m_value).append(",DisplayType=").append(this.getDisplayType()).append("]");
        return sb.toString();
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.addPropertyChangeListener(l);
    }

    public static GridField[] createFields(Properties ctx, int WindowNo, int TabNo, int AD_Tab_ID) {
        ArrayList<GridFieldVO> listVO;
        block7: {
            listVO = new ArrayList<GridFieldVO>();
            int AD_Window_ID = 0;
            boolean readOnly = false;
            String sql = GridFieldVO.getSQL(ctx);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Tab_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        GridFieldVO vo = GridFieldVO.create(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly, rs);
                        listVO.add(vo);
                    }
                    Collections.sort(listVO, new GridFieldVO.SeqNoComparator());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        GridField[] retValue = new GridField[listVO.size()];
        int i = 0;
        while (i < listVO.size()) {
            retValue[i] = new GridField((GridFieldVO)listVO.get(i));
            ++i;
        }
        return retValue;
    }

    private boolean isIndirectParentValue() {
        boolean result = false;
        int tabNo = this.m_vo.TabNo;
        int currentLevel = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, tabNo, "_TabInfo_TabLevel");
        if (tabNo > 1 && currentLevel > 1) {
            while (tabNo >= 1 && !result) {
                int level;
                if ((level = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, --tabNo, "_TabInfo_TabLevel")) <= 0 || level >= currentLevel) continue;
                String linkColumn = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, tabNo, "_TabInfo_LinkColumnName");
                if (this.m_vo.ColumnName.equals(linkColumn)) {
                    result = true;
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(result + " - Link(" + linkColumn + ", W=" + this.m_vo.WindowNo + ",T=" + this.m_vo.TabNo + ") = " + this.m_vo.ColumnName);
                    }
                }
                currentLevel = level;
            }
        }
        return result;
    }

    private final void backupValue() {
        if (!this.m_isBackupValue) {
            this.m_backupValue = this.get_ValueAsString(this.m_vo.ColumnName);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Backup " + this.m_vo.WindowNo + "|" + this.m_vo.ColumnName + "=" + this.m_backupValue);
            }
            this.m_isBackupValue = true;
        }
    }

    public void restoreValue() {
        if (this.m_isBackupValue) {
            if (this.isParentTabField()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Restore " + this.m_vo.WindowNo + "|" + this.m_vo.TabNo + "|" + this.m_vo.ColumnName + "=" + this.m_backupValue);
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.ColumnName, this.m_backupValue);
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Restore " + this.m_vo.WindowNo + "|" + this.m_vo.ColumnName + "=" + this.m_backupValue);
                }
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.ColumnName, this.m_backupValue);
            }
        }
    }

    public void setVFormat(String strNewFormat) {
        this.m_vo.VFormat = strNewFormat;
    }

    public int getIncluded_Tab_ID() {
        return this.m_vo.Included_Tab_ID;
    }

    public void setIsCollapsedByDefault(boolean flag) {
        this.m_vo.IsCollapsedByDefault = flag;
    }

    public boolean getIsCollapsedByDefault() {
        return this.m_vo.IsCollapsedByDefault;
    }

    public List<String> getEntries() {
        ArrayList<String> list;
        block7: {
            MColumn column = MColumn.get(Env.getCtx(), this.getAD_Column_ID());
            MTable table2 = MTable.get(Env.getCtx(), column.getAD_Table_ID());
            String tableName = table2.getTableName();
            String columnName = column.getColumnName();
            list = new ArrayList<String>();
            if (tableName != null && columnName != null) {
                int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                StringBuilder sql = new StringBuilder().append("SELECT DISTINCT ").append(columnName).append(" FROM ").append(tableName).append(" WHERE AD_Client_ID=? AND ").append(columnName).append(" IS NOT NULL ORDER BY 1");
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setInt(1, AD_Client_ID);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            list.add(rs.getString(1));
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, sql.toString(), e);
                        DB.close(rs, pstmt);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        return list;
    }

    public void setGridTab(GridTab gridTab) {
        this.m_gridTab = gridTab;
    }

    public GridTab getGridTab() {
        return this.m_gridTab;
    }

    private boolean isParentTabField(String columnName) {
        if (this.m_gridTab == null) {
            return false;
        }
        GridTab parentTab = this.m_gridTab.getParentTab();
        while (parentTab != null) {
            if (parentTab.getField(columnName) != null) {
                return true;
            }
            parentTab = parentTab.getParentTab();
        }
        return false;
    }

    private boolean isParentTabField() {
        return this.isParentTabField(this.m_vo.ColumnName);
    }

    private boolean isUpdateWindowContext() {
        if (this.getGridTab() != null) {
            return this.getGridTab().isUpdateWindowContext();
        }
        return true;
    }

    public int getXPosition() {
        return this.m_vo.XPosition;
    }

    public int getColumnSpan() {
        return this.m_vo.ColumnSpan;
    }

    public int getNumLines() {
        return this.m_vo.NumLines;
    }

    public boolean isToolbarButton() {
        return this.m_vo.displayType == 28 && ("Y".equals(this.m_vo.IsToolbarButton) || "B".equals(this.m_vo.IsToolbarButton));
    }

    public boolean isToolbarOnlyButton() {
        return this.m_vo.displayType == 28 && "Y".equals(this.m_vo.IsToolbarButton);
    }

    public boolean isLockedRecord() {
        return this.m_lockedRecord;
    }

    public void setLockedRecord(boolean lockedRecord) {
        this.m_lockedRecord = lockedRecord;
    }

    public int getPA_DashboardContent_ID() {
        return this.m_vo.PA_DashboardContent_ID;
    }

    public String getPlaceholder() {
        return this.m_vo.Placeholder;
    }

    public String getPlaceholder2() {
        return this.m_vo.Placeholder2;
    }

    public void setPlaceholder(String placeholder) {
        this.m_vo.Placeholder = placeholder;
    }

    public GridField clone(Properties ctx) {
        try {
            GridField field = (GridField)super.clone();
            field.m_vo = field.m_vo.clone(ctx, field.m_vo.WindowNo, field.m_vo.TabNo, field.m_vo.AD_Window_ID, field.m_vo.AD_Tab_ID, field.m_vo.tabReadOnly);
            field.m_vo.lookupInfo = null;
            field.m_lookup = null;
            field.m_propertyChangeListeners = new PropertyChangeSupport(this);
            return field;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    public void setLookupEditorSettingValue(boolean b2) {
        this.m_lookupEditorSettingValue = b2;
    }

    public boolean isLookupEditorSettingValue() {
        return this.m_lookupEditorSettingValue;
    }

    public boolean isQuickForm() {
        return this.m_vo.IsQuickForm;
    }

    public String getDateRangeOption() {
        return this.m_vo.dateRangeOption;
    }

    public void processUIVirtualColumn() {
        String sql = this.m_vo.ColumnSQL.substring(5);
        sql = Env.parseContext(Env.getCtx(), this.getWindowNo(), sql, false);
        if (Util.isEmpty(sql)) {
            this.setValue(null, false);
        } else if (DisplayType.isDate(this.m_vo.displayType)) {
            Timestamp valueTS = DB.getSQLValueTSEx(null, sql, new Object[0]);
            this.setValue(valueTS, false);
        } else if (DisplayType.isNumeric(this.m_vo.displayType)) {
            BigDecimal valueBD = DB.getSQLValueBDEx(null, sql, new Object[0]);
            this.setValue(valueBD, false);
        } else if (DisplayType.isID(this.m_vo.displayType)) {
            int valueInt = DB.getSQLValueEx(null, sql, new Object[0]);
            this.setValue(valueInt, false);
        } else {
            String valueStr = DB.getSQLValueStringEx(null, sql, new Object[0]);
            this.setValue(valueStr, false);
        }
    }

    public void setParentEvaluatee(Evaluatee evaluatee) {
        this.m_parentEvaluatee = evaluatee;
    }
}

