/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InvoiceTest
extends AbstractTestCase {
    @Test
    public void testCreditCheckInvoice() {
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id, (String)this.getTrxName());
        bp.setSOCreditStatus("S");
        bp.saveEx();
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(bp);
        invoice.setAD_Org_ID(DictionaryIDs.AD_Org.HQ.id);
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setM_PriceList_ID(DictionaryIDs.M_PriceList.STANDARD.id);
        invoice.setPaymentRule("P");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(Env.getCtx(), 0, this.getTrxName());
        invoiceLine.setInvoice(invoice);
        invoiceLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
        invoiceLine.setAD_Org_ID(DictionaryIDs.AD_Org.HQ.id);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.FERTILIZER_50.id));
        invoiceLine.setQty(new BigDecimal("1"));
        invoiceLine.saveEx();
        invoice.load(this.getTrxName(), new String[0]);
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"PR");
        Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IN", (Object)invoice.getDocStatus());
        bp.setSOCreditStatus("X");
        bp.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
    }
}

