/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MLocatorType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MStorageTest
extends AbstractTestCase {
    @Test
    public void testStorageOnHandAndReservation() {
        MProduct azalea = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        BigDecimal onhandForReservation = MStorageOnHand.getQtyOnHandForReservation((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        BigDecimal onhandForShipping = MStorageOnHand.getQtyOnHandForShipping((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        BigDecimal qtyReserved = MStorageReservation.getQty((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)true, (String)this.getTrxName());
        BigDecimal availableForReservation = MStorageReservation.getQtyAvailable((int)this.getM_Warehouse_ID(), (int)azalea.getM_Product_ID(), (int)0, (String)this.getTrxName());
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(azalea);
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        BigDecimal qtyReserved1 = MStorageReservation.getQty((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)true, (String)this.getTrxName());
        Assertions.assertTrue((qtyReserved1.compareTo(qtyReserved) > 0 ? 1 : 0) != 0, (String)("Qty reserved doesn't increase as expected (Before=" + qtyReserved.toPlainString() + " After=" + qtyReserved1.toPlainString()));
        BigDecimal availableForReservation1 = MStorageReservation.getQtyAvailable((int)this.getM_Warehouse_ID(), (int)azalea.getM_Product_ID(), (int)0, (String)this.getTrxName());
        Assertions.assertTrue((availableForReservation1.compareTo(availableForReservation) < 0 ? 1 : 0) != 0, (String)("Qty available for reservation doesn't reduce as expected (Before=" + availableForReservation.toPlainString() + " After=" + availableForReservation1.toPlainString()));
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        BigDecimal onhandForReservation1 = MStorageOnHand.getQtyOnHandForReservation((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        Assertions.assertTrue((onhandForReservation1.compareTo(onhandForReservation) < 0 ? 1 : 0) != 0, (String)("Qty on hand for reservation doesn't reduce as expected (Before=" + onhandForReservation.toPlainString() + " After=" + onhandForReservation1.toPlainString()));
        BigDecimal onhandForShipping1 = MStorageOnHand.getQtyOnHandForShipping((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        Assertions.assertTrue((onhandForShipping1.compareTo(onhandForShipping) < 0 ? 1 : 0) != 0, (String)("Qty on hand for shipping doesn't reduce as expected (Before=" + onhandForShipping.toPlainString() + " After=" + onhandForShipping1.toPlainString()));
        MLocatorType reservedLocatorType = new MLocatorType(Env.getCtx(), 0, this.getTrxName());
        reservedLocatorType.setName("Reserved Locator1");
        reservedLocatorType.setIsAvailableForReservation(true);
        reservedLocatorType.setIsAvailableForReplenishment(false);
        reservedLocatorType.setIsAvailableForShipping(false);
        reservedLocatorType.saveEx();
        MLocatorType shippingLocatorType = new MLocatorType(Env.getCtx(), 0, this.getTrxName());
        shippingLocatorType.setName("Shipping Locator1");
        shippingLocatorType.setIsAvailableForReservation(false);
        shippingLocatorType.setIsAvailableForReplenishment(false);
        shippingLocatorType.setIsAvailableForShipping(true);
        shippingLocatorType.saveEx();
        MLocator shippingLocator = new MLocator(Env.getCtx(), 0, this.getTrxName());
        shippingLocator.setM_LocatorType_ID(shippingLocatorType.getM_LocatorType_ID());
        shippingLocator.setM_Warehouse_ID(this.getM_Warehouse_ID());
        shippingLocator.setXYZ("x1", "y1", "z1");
        shippingLocator.saveEx();
        MMovement movement = new MMovement(Env.getCtx(), 0, this.getTrxName());
        movement.setC_DocType_ID(DictionaryIDs.C_DocType.MATERIAL_MOVEMENT.id);
        movement.setDocAction("CO");
        movement.saveEx();
        MStorageOnHand[] storages = MStorageOnHand.getWarehouse((Properties)Env.getCtx(), (int)this.getM_Warehouse_ID(), (int)azalea.getM_Product_ID(), (int)0, null, (boolean)true, (boolean)true, (int)0, (String)this.getTrxName(), (boolean)false);
        int[] line = new int[1];
        Arrays.stream(storages).forEach(e -> {
            MMovementLine ml = new MMovementLine(movement);
            ml.setM_Product_ID(azalea.getM_Product_ID());
            nArray[0] = line[0] + 10;
            ml.setLine(line[0]);
            ml.setM_Locator_ID(e.getM_Locator_ID());
            ml.setM_LocatorTo_ID(shippingLocator.getM_Locator_ID());
            ml.setMovementQty(new BigDecimal("1"));
            ml.saveEx();
            MLocator locator = new MLocator(Env.getCtx(), e.getM_Locator_ID(), this.getTrxName());
            locator.setM_LocatorType_ID(reservedLocatorType.getM_LocatorType_ID());
            locator.saveEx();
        });
        info = MWorkflow.runDocumentActionWorkflow((PO)movement, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        movement.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)movement.getDocStatus());
        BigDecimal onhandForReservation2 = MStorageOnHand.getQtyOnHandForReservation((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        Assertions.assertTrue((onhandForReservation2.compareTo(onhandForReservation1) < 0 ? 1 : 0) != 0, (String)("Qty on hand for reservation doesn't reduce as expected (Before=" + onhandForReservation1.toPlainString() + " After=" + onhandForReservation2.toPlainString()));
        BigDecimal onhandForShipping2 = MStorageOnHand.getQtyOnHandForShipping((int)azalea.getM_Product_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        Assertions.assertTrue((onhandForShipping2.compareTo(onhandForShipping1) < 0 ? 1 : 0) != 0, (String)("Qty on hand for shipping doesn't reduce as expected (Before=" + onhandForShipping1.toPlainString() + " After=" + onhandForShipping2.toPlainString()));
    }
}

