/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.compiere.Adempiere;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogger;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.idempiere.hazelcast.service.CacheConsoleProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    protected static final CLogger logger;
    private static volatile HazelcastInstance hazelcastInstance;

    static {
        logger = CLogger.getCLogger((String)Activator.class.getName());
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        if (Adempiere.isStarted()) {
            Activator.createHazelCastInstance();
        } else {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                public void stateChange(ServerStateChangeEvent event) {
                    if (event.getEventType() == 0) {
                        Activator.createHazelCastInstance();
                    }
                }
            });
        }
        bundleContext.registerService(CommandProvider.class.getName(), (Object)new CacheConsoleProvider(), null);
    }

    private static synchronized void createHazelCastInstance() {
        Enumeration entries;
        URL url;
        File file = null;
        String dataArea = SystemProperties.getIdempiereHome();
        if (dataArea != null && dataArea.trim().length() > 0) {
            try {
                file = new File(dataArea, "hazelcast.xml");
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception exception) {}
        }
        if (file == null && (dataArea = System.getProperty("user.dir")) != null && dataArea.trim().length() > 0) {
            try {
                file = new File(dataArea, "hazelcast.xml");
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception exception) {}
        }
        if (file == null && (dataArea = System.getProperty("osgi.install.area")) != null && dataArea.trim().length() > 0) {
            try {
                URL url2 = new URL(dataArea);
                file = new File(url2.getPath(), "hazelcast.xml");
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception exception) {}
        }
        if (file == null && (dataArea = System.getProperty("hazelcast.config")) != null && dataArea.trim().length() > 0) {
            try {
                file = new File(dataArea);
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception exception) {}
        }
        if (file != null && file.exists()) {
            try {
                FileSystemXmlConfig config = new FileSystemXmlConfig(file);
                config.setClassLoader(Activator.class.getClassLoader());
                logger.warning("Starting hazelcast with configuration from file " + file.getName());
                hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
                MapConfig mc = config.getMapConfig("default");
                if (mc != null) {
                    logger.info("Hazelcast Max Size Config: " + String.valueOf(mc.getEvictionConfig().getMaxSizePolicy()) + " " + mc.getEvictionConfig().getSize());
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        URL uRL = url = (entries = Activator.getContext().getBundle().findEntries("/", "hazelcast.xml", false)) != null && entries.hasMoreElements() ? (URL)entries.nextElement() : null;
        if (url != null) {
            try {
                UrlXmlConfig config = new UrlXmlConfig(url);
                config.setClassLoader(Activator.class.getClassLoader());
                logger.warning("Starting hazelcast with configuration from URL " + url.toString());
                hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
                MapConfig mc = config.getMapConfig("default");
                if (mc != null) {
                    logger.info("Hazelcast Max Size Config: " + String.valueOf(mc.getEvictionConfig().getMaxSizePolicy()) + " " + mc.getEvictionConfig().getSize());
                }
                return;
            }
            catch (IOException iOException) {}
        }
        Config config = new Config();
        config.setClassLoader(Activator.class.getClassLoader());
        hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        logger.warning("Starting hazelcast with default configuration");
        MapConfig mc = config.getMapConfig("default");
        if (mc != null) {
            logger.info("Hazelcast Max Size Config: " + String.valueOf(mc.getEvictionConfig().getMaxSizePolicy()) + " " + mc.getEvictionConfig().getSize());
        }
    }

    public static synchronized HazelcastInstance getHazelcastInstance() {
        if (hazelcastInstance != null && !hazelcastInstance.getLifecycleService().isRunning()) {
            System.err.println(DateFormat.getDateTimeInstance().format(new Date()) + " Hazelcast instance is down!");
            try {
                hazelcastInstance = Hazelcast.newHazelcastInstance(null);
                if (!hazelcastInstance.getLifecycleService().isRunning()) {
                    hazelcastInstance = null;
                    System.err.println(DateFormat.getDateTimeInstance().format(new Date()) + " Failed to re-create Hazelcast instance!");
                } else {
                    System.err.println(DateFormat.getDateTimeInstance().format(new Date()) + " Hazelcast instance re-created!");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                hazelcastInstance = null;
                System.err.println(DateFormat.getDateTimeInstance().format(new Date()) + " Failed to re-create Hazelcast instance!");
            }
        }
        return hazelcastInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            if (hazelcastInstance != null) {
                hazelcastInstance.getLifecycleService().shutdown();
                hazelcastInstance = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

