/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.DesktopRecycles;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopRecycle;

public class RichletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RichletFilter.class);
    private FilterConfig _config;
    private WebManager _webman;
    private boolean _compress = true;

    public void init(FilterConfig config) throws ServletException {
        this._config = config;
        String param = config.getInitParameter("compress");
        this._compress = param == null || param.length() == 0 || "true".equals(param);
        ServletContext ctx = this._config.getServletContext();
        this._webman = WebManager.getWebManagerIfAny(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block11: {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest reg = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                Session sess = WebManager.getSession(this._config.getServletContext(), (HttpServletRequest)request);
                String path = Https.getThisPathInfo((ServletRequest)request);
                if (path == null) {
                    path = Https.getThisServletPath((ServletRequest)request);
                }
                try {
                    Object old = I18Ns.setup(sess, request, response, sess.getWebApp().getConfiguration().getResponseCharset());
                    try {
                        if (!this.process(sess, reg, resp, path, true)) break block11;
                        return;
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        I18Ns.cleanup(request, old);
                    }
                }
                finally {
                    SessionsCtrl.requestExit(sess);
                }
            }
        }
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Session sess, HttpServletRequest request, HttpServletResponse response, String path, boolean bRichlet) throws ServletException, IOException {
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Configuration config = wapp.getConfiguration();
        boolean bInclude = Servlets.isIncluded((ServletRequest)request);
        boolean compress = this._compress && !bInclude;
        Writer out = compress ? new StringWriter() : response.getWriter();
        DesktopRecycle dtrc = bInclude ? null : config.getDesktopRecycle();
        ServletContext ctx = this._config.getServletContext();
        Desktop desktop = dtrc != null ? DesktopRecycles.beforeService(dtrc, ctx, sess, request, response, path) : null;
        try {
            if (desktop != null) {
                Page page = Utils.getMainPage(desktop);
                if (page != null) {
                    ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, page);
                    WebManager.setDesktop(request, desktop);
                    wappc.getUiEngine().recycleDesktop(exec, page, out);
                } else {
                    desktop = null;
                }
            }
            if (desktop == null) {
                desktop = this._webman.getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
                if (desktop == null) {
                    boolean page = true;
                    return page;
                }
                RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, request, PageDefinitions.getLocator(wapp, path));
                ((SessionCtrl)((Object)sess)).notifyClientRequest(true);
                UiFactory uf = wappc.getUiFactory();
                if (uf.isRichlet(ri, bRichlet)) {
                    Richlet richlet = uf.getRichlet(ri, path);
                    if (richlet == null) {
                        boolean bl = false;
                        return bl;
                    }
                    Page page = WebManager.newPage(uf, (RequestInfo)ri, richlet, (ServletResponse)response, path);
                    ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, page);
                    wappc.getUiEngine().execNewPage((Execution)exec, richlet, page, out);
                } else {
                    boolean richlet = false;
                    return richlet;
                }
            }
            if (compress) {
                String result = ((StringWriter)out).toString();
                try {
                    byte[] bs;
                    ServletOutputStream os = response.getOutputStream();
                    byte[] data = result.getBytes(config.getResponseCharset());
                    if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                        data = bs;
                    }
                    response.setContentLength(data.length);
                    os.write(data);
                    response.flushBuffer();
                }
                catch (IllegalStateException ex) {
                    response.getWriter().write(result);
                }
            }
        }
        finally {
            if (dtrc != null) {
                DesktopRecycles.afterService(dtrc, desktop);
            }
        }
        return true;
    }

    public void destroy() {
        this._config = null;
        this._webman = null;
    }
}

